#include <iostream>
#include <fstream>
#include <cmath>
#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <string>
#include <vector>
#include <set>
#include <map>
#include <iomanip>
#include <algorithm>

#define DBGIN_
#define DBG_

typedef long long ll;
typedef long double ld;

using namespace std;

int main() {
	//freopen("in.txt", "rt", stdin);

	vector<vector<int> > answers;

	int n;
	cin >> n;
	set<int> slopes[101];
	set<int> roots;
	for (int i = 1; i <=n; ++i) {
		roots.insert(i);
	}

	for (int i = 1; i <= n; ++i) {
		int sc, st;
		cin >> sc;
#ifdef DBGIN
		cout << "Vertex #" << i << " slopes: " << sc << endl;
#endif
		for (int j = 0; j < sc; ++j) {
			cin >> st;
			slopes[i].insert(st);
			set<int>::iterator it = roots.find(st);
			if (it != roots.end())
				roots.erase(it);
#ifdef DBGIN
			cout << st << ' ';
#endif
		}
#ifdef DBGIN
		cout << endl;
#endif
	}

	while (!roots.empty()) {
		set<int>::iterator curRoot = roots.begin();
		int root = *curRoot;
		roots.erase(curRoot);
#ifdef DBG
		cout << "Starting at vertex #" << root << endl;
#endif
		vector<int> path;
		path.push_back(root);
		set<int> *p = slopes + root;
		bool promote;
		while (!p->empty()) {
#ifdef DBG
			cout << "Entered " << root << ", possible slopes: ";
			for (set<int>::iterator it = p->begin(); it != p->end(); ++it)
				cout << *it << ' ';
			cout << endl;
#endif

			if (p->size() == 1) {
#ifdef DBG
				cout << "Prom ON" << endl;
#endif
				promote = true;
			} else {
#ifdef DBG
				cout << "New root: " << root << endl;
#endif
				roots.insert(root);
				promote = false;
			}
			set<int>::iterator it = p->begin();
			root = *it;
#ifdef DBG
			cout << "We selected slope: " << root << endl;
#endif
			path.push_back(root);
			p->erase(it);
			p = slopes + root;
#ifdef DBG
			cout << "Next in path: " << root << endl;
#endif
		}
		answers.push_back(path);
	}

	cout << answers.size() << endl;
	for (vector<vector<int> >::iterator it = answers.begin(); it != answers.end(); ++it) {
		for (vector<int>::iterator it2 = it->begin(); it2 != it->end(); ++it2)
			cout << *it2 << ' ';
		cout << endl;
	}

	return 0;
}